<?php
header('Content-Type: text/plain');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') exit(0);

// Database configuration - APNA DATABASE CREDENTIALS DAALEIN
define('DB_HOST', 'localhost');
define('DB_USER', 'bbteammo_Deepakhhh'); // Change to your username
define('DB_PASS', 'bbteammo_Deepakhhh'); // Change to your password
define('DB_NAME', 'bbteammo_Deepakhhh'); // Create this database

// ✅ IMPROVED: CREATE PROPER TABLES FUNCTION
function createTablesIfNotExists() {
    // Create connection without database
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);
    
    if ($conn->connect_error) {
        return false;
    }
    
    // Create database if not exists
    if (!$conn->query("CREATE DATABASE IF NOT EXISTS " . DB_NAME)) {
        // If database creation fails, try to continue
    }
    
    $conn->select_db(DB_NAME);
    
    // Main users table
    $sql_users = "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id VARCHAR(255) NOT NULL,
        device_id VARCHAR(255) NOT NULL,
        first_seen DATETIME DEFAULT CURRENT_TIMESTAMP,
        last_seen DATETIME DEFAULT CURRENT_TIMESTAMP,
        ip_address VARCHAR(45),
        user_agent TEXT,
        request_count INT DEFAULT 1,
        app_version VARCHAR(50),
        is_active BOOLEAN DEFAULT TRUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_user_id (user_id),
        INDEX idx_device_id (device_id),
        INDEX idx_last_seen (last_seen),
        INDEX idx_app_version (app_version)
    )";
    
    // Version-wise statistics table
    $sql_version_stats = "CREATE TABLE IF NOT EXISTS version_statistics (
        id INT AUTO_INCREMENT PRIMARY KEY,
        app_version VARCHAR(50) NOT NULL,
        total_users INT DEFAULT 0,
        active_users INT DEFAULT 0,
        total_requests INT DEFAULT 0,
        first_seen DATETIME DEFAULT CURRENT_TIMESTAMP,
        last_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_version (app_version)
    )";
    
    $conn->query($sql_users);
    $conn->query($sql_version_stats);
    $conn->close();
    return true;
}

// ✅ SIMPLE USER TRACKING FUNCTION
function trackUser($userId, $deviceId, $appVersion) {
    // First create tables
    createTablesIfNotExists();
    
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        return false;
    }
    
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    $timestamp = date('Y-m-d H:i:s');
    
    // Check if user exists
    $checkQuery = "SELECT id, app_version, request_count FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($checkQuery);
    
    if (!$stmt) {
        // If prepare fails, try direct query
        $conn->close();
        return trackUserSimple($userId, $deviceId, $appVersion, $ip, $userAgent, $timestamp);
    }
    
    $stmt->bind_param("s", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        // Update existing user
        $row = $result->fetch_assoc();
        $oldVersion = $row['app_version'];
        $newCount = $row['request_count'] + 1;
        
        $updateQuery = "UPDATE users SET last_seen = ?, request_count = ?, app_version = ?, ip_address = ?, user_agent = ? WHERE user_id = ?";
        $updateStmt = $conn->prepare($updateQuery);
        
        if ($updateStmt) {
            $updateStmt->bind_param("sissss", $timestamp, $newCount, $appVersion, $ip, $userAgent, $userId);
            $updateStmt->execute();
            $updateStmt->close();
        }
        
        // Update version statistics
        updateVersionStats($appVersion, $oldVersion);
        
    } else {
        // Insert new user
        $insertQuery = "INSERT INTO users (user_id, device_id, first_seen, last_seen, ip_address, user_agent, request_count, app_version) VALUES (?, ?, ?, ?, ?, ?, 1, ?)";
        $insertStmt = $conn->prepare($insertQuery);
        
        if ($insertStmt) {
            $insertStmt->bind_param("sssssss", $userId, $deviceId, $timestamp, $timestamp, $ip, $userAgent, $appVersion);
            $insertStmt->execute();
            $insertStmt->close();
            
            // Update version statistics for new user
            updateVersionStats($appVersion, null, true);
        }
    }
    
    $stmt->close();
    $conn->close();
    return true;
}

// ✅ SIMPLE TRACKING FALLBACK
function trackUserSimple($userId, $deviceId, $appVersion, $ip, $userAgent, $timestamp) {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) return false;
    
    createTablesIfNotExists();
    
    // Simple insert or update
    $check = $conn->query("SELECT id FROM users WHERE user_id = '$userId'");
    
    if ($check && $check->num_rows > 0) {
        // Update
        $conn->query("UPDATE users SET last_seen = '$timestamp', request_count = request_count + 1, app_version = '$appVersion' WHERE user_id = '$userId'");
    } else {
        // Insert
        $conn->query("INSERT INTO users (user_id, device_id, first_seen, last_seen, ip_address, user_agent, app_version) VALUES ('$userId', '$deviceId', '$timestamp', '$timestamp', '$ip', '$userAgent', '$appVersion')");
    }
    
    // Update version stats
    updateVersionStatsSimple($appVersion);
    
    $conn->close();
    return true;
}

// ✅ SIMPLE VERSION STATS UPDATE
function updateVersionStatsSimple($appVersion) {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) return;
    
    $timestamp = date('Y-m-d H:i:s');
    
    // Check if version exists
    $check = $conn->query("SELECT total_users FROM version_statistics WHERE app_version = '$appVersion'");
    
    if ($check && $check->num_rows > 0) {
        // Update existing
        $conn->query("UPDATE version_statistics SET total_users = total_users + 1, last_updated = '$timestamp' WHERE app_version = '$appVersion'");
    } else {
        // Insert new
        $conn->query("INSERT INTO version_statistics (app_version, total_users) VALUES ('$appVersion', 1)");
    }
    
    $conn->close();
}

// ✅ VERSION STATS UPDATE
function updateVersionStats($newVersion, $oldVersion = null, $isNewUser = false) {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) return;
    
    $timestamp = date('Y-m-d H:i:s');
    
    // If version changed and not new user, decrement old version
    if ($oldVersion && $oldVersion != $newVersion && !$isNewUser) {
        $conn->query("UPDATE version_statistics SET total_users = GREATEST(0, total_users - 1) WHERE app_version = '$oldVersion'");
    }
    
    // Update or insert new version
    $check = $conn->query("SELECT total_users FROM version_statistics WHERE app_version = '$newVersion'");
    
    if ($check && $check->num_rows > 0) {
        $conn->query("UPDATE version_statistics SET total_users = total_users + 1, last_updated = '$timestamp' WHERE app_version = '$newVersion'");
    } else {
        $conn->query("INSERT INTO version_statistics (app_version, total_users) VALUES ('$newVersion', 1)");
    }
    
    $conn->close();
}

// ✅ GET STATISTICS FOR ADMIN
function getStatistics() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        return ['total_users' => 0, 'active_users' => 0, 'new_today' => 0, 'new_week' => 0, 'total_requests' => 0];
    }
    
    $stats = [];
    
    // Total unique users
    $result = $conn->query("SELECT COUNT(DISTINCT user_id) as total FROM users");
    $stats['total_users'] = $result ? $result->fetch_assoc()['total'] : 0;
    
    // Active users (last 24 hours)
    $timeThreshold = date('Y-m-d H:i:s', strtotime('-24 hours'));
    $result = $conn->query("SELECT COUNT(DISTINCT user_id) as active FROM users WHERE last_seen > '$timeThreshold'");
    $stats['active_users'] = $result ? $result->fetch_assoc()['active'] : 0;
    
    // Today's new users
    $todayStart = date('Y-m-d 00:00:00');
    $result = $conn->query("SELECT COUNT(DISTINCT user_id) as new_today FROM users WHERE first_seen >= '$todayStart'");
    $stats['new_today'] = $result ? $result->fetch_assoc()['new_today'] : 0;
    
    // This week's new users
    $weekStart = date('Y-m-d 00:00:00', strtotime('-7 days'));
    $result = $conn->query("SELECT COUNT(DISTINCT user_id) as new_week FROM users WHERE first_seen >= '$weekStart'");
    $stats['new_week'] = $result ? $result->fetch_assoc()['new_week'] : 0;
    
    // Total requests
    $result = $conn->query("SELECT SUM(request_count) as total_requests FROM users");
    $stats['total_requests'] = $result ? ($result->fetch_assoc()['total_requests'] ?? 0) : 0;
    
    // Version statistics
    $stats['version_stats'] = [];
    $result = $conn->query("SELECT app_version, total_users FROM version_statistics ORDER BY last_updated DESC");
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $stats['version_stats'][] = $row;
        }
    }
    
    // Recent users
    $stats['recent_users'] = [];
    $result = $conn->query("SELECT user_id, device_id, first_seen, last_seen, request_count, app_version FROM users ORDER BY last_seen DESC LIMIT 10");
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $stats['recent_users'][] = $row;
        }
    }
    
    $conn->close();
    return $stats;
}

// Get current settings from admin panel
function getAppSettings() {
    if (file_exists('app_settings.json')) {
        $settings = json_decode(file_get_contents('app_settings.json'), true);
        if ($settings && json_last_error() === JSON_ERROR_NONE) {
            return $settings;
        }
    }
    
    // Default settings
    return [
        'expiry_date' => date('Y-m-d', strtotime('+30 days')),
        'custom_message' => '✨ NOVA STRIKE MODS\n🚫 Version Expired!\n\n📢 Update to latest version.',
        'telegram_url' => 'https://t.me/novastrikemods',
        'latest_version' => '1.0.0',
        'update_url' => 'https://t.me/novastrikemods',
        'changelog' => '• Initial Release\n• Bug Fixes\n• Performance Improvements',
        'force_update' => 'no',
        'updated_at' => date('Y-m-d H:i:s')
    ];
}

// Create settings file if not exists
function createSettingsFile() {
    if (!file_exists('app_settings.json')) {
        $defaultSettings = [
            'expiry_date' => date('Y-m-d', strtotime('+30 days')),
            'custom_message' => '✨ NOVA STRIKE MODS\n🚫 Version Expired!\n\n📢 Update to latest version.',
            'telegram_url' => 'https://t.me/novastrikemods',
            'latest_version' => '1.0.0',
            'update_url' => 'https://t.me/novastrikemods',
            'changelog' => '• Initial Release\n• Bug Fixes\n• Performance Improvements',
            'force_update' => 'no',
            'updated_at' => date('Y-m-d H:i:s')
        ];
        @file_put_contents('app_settings.json', json_encode($defaultSettings, JSON_PRETTY_PRINT));
    }
}

// ✅ DEBUG FUNCTION - Check if tracking is working
function debugTracking($userId, $deviceId, $appVersion) {
    $logFile = 'debug_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] User: $userId, Device: $deviceId, Version: $appVersion\n";
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

// Main control logic
if (isset($_GET['action']) && $_GET['action'] == 'check') {
    $userId = $_GET['user_id'] ?? 'unknown_' . time();
    $deviceId = $_GET['device_id'] ?? 'unknown_device';
    $appVersion = $_GET['version'] ?? 'unknown_version';
    
    // ✅ DEBUG LOG
    debugTracking($userId, $deviceId, $appVersion);
    
    // ✅ USER TRACKING - SIMPLE AND RELIABLE
    $trackingSuccess = trackUser($userId, $deviceId, $appVersion);
    
    // Admin panel se settings lo
    $settings = getAppSettings();
    $expiryDate = $settings['expiry_date'];
    $customMessage = $settings['custom_message'];
    $telegramUrl = $settings['telegram_url'];
    $latestVersion = $settings['latest_version'];
    $updateUrl = $settings['update_url'];
    $changelog = $settings['changelog'];
    $forceUpdate = $settings['force_update'] ?? 'no';
    
    // Version check - Agar version match nahi karta to expire
    $isUpdateAvailable = version_compare($appVersion, $latestVersion, '<');
    $isExpiredByDate = (date('Y-m-d') > $expiryDate);
    $isExpiredByVersion = ($forceUpdate == 'yes' && $isUpdateAvailable);
    
    if ($isExpiredByDate || $isExpiredByVersion) {
        // Expired - Clean message with online Telegram URL
        $finalMessage = str_replace("\\n", "\n", $customMessage);
        echo "STATUS:EXPIRED|MESSAGE:" . $finalMessage . "|TELEGRAM:" . $telegramUrl . "|UPDATE_AVAILABLE:" . ($isUpdateAvailable ? 'YES' : 'NO') . "|LATEST_VERSION:" . $latestVersion . "|UPDATE_URL:" . $updateUrl . "|CHANGELOG:" . $changelog;
    } else {
        // Active - Online Telegram URL ke saath
        $daysLeft = max(0, floor((strtotime($expiryDate) - time()) / (60 * 60 * 24)));
        echo "STATUS:ACTIVE|MESSAGE:Welcome to NOVA STRIKE MODS|DAYS_LEFT:" . $daysLeft . "|TELEGRAM:" . $telegramUrl . "|UPDATE_AVAILABLE:" . ($isUpdateAvailable ? 'YES' : 'NO') . "|LATEST_VERSION:" . $latestVersion . "|UPDATE_URL:" . $updateUrl . "|CHANGELOG:" . $changelog;
    }
    exit;
}

// ✅ TEST FUNCTION - Manually check statistics
if (isset($_GET['action']) && $_GET['action'] == 'test_stats') {
    $stats = getStatistics();
    header('Content-Type: application/json');
    echo json_encode($stats, JSON_PRETTY_PRINT);
    exit;
}

// ✅ RESET FUNCTION - Clear all data
if (isset($_GET['action']) && $_GET['action'] == 'reset_stats') {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if (!$conn->connect_error) {
        $conn->query("DELETE FROM users");
        $conn->query("DELETE FROM version_statistics");
        $conn->close();
        echo "Statistics reset successfully!";
    } else {
        echo "Failed to reset statistics!";
    }
    exit;
}

// Initialize
createTablesIfNotExists();
createSettingsFile();

// ✅ DEFAULT RESPONSE IF NO ACTION
echo "NOVA STRIKE MODS CONTROL PANEL - ACTIVE";
?>